package org.msh.tb.reports2.me;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.msh.tb.entities.enums.CaseClassification;

import java.util.List;

/**
 * Created by rmemoria on 7/12/16.
 */
@Name("meReportService")
@AutoCreate
@Scope(ScopeType.APPLICATION)
public class MeReportService {


    @Transactional
    public List<TableData> execute(MeReportId id, Integer unitId, Integer adminUnitId,
                                   Integer quarter, Integer year, CaseClassification classification) {
        IndicatorBuilder builder = new IndicatorBuilder(unitId, adminUnitId, quarter, year, classification);

        switch (id) {
            case PRESUMPTIVE: return PresumptiveReport.generate(builder);
            case CASE_FINDING: return CaseFindingReport.generate(builder);
            case HIV_STATUS: return HIVReport.generate(builder);
            case SPUTUM_CONVERSION: return SputumConversionReport.generate(builder);
            case COHORT: return CohortReport.generate(builder);
            case COHORT_IPT: return CohortIPTReport.generate(builder);
            default: return null;
        }
    }

}
